<?php
/**
 * Generiert Content bei zugriff auf accountsettings.php
 */

/**
 * Stellt dem User bearbeitungsmöglichkeiten für seine Daten zur Verfügung
 * @package     content
 * @author      Stefan Meyer
 * @version     v.0.9 
 * @copyright   Copyright (c) 2018, Stefan 
 */

/**
 * Generiert den standartcontent beim accountsettings aufruf
 * @return string $json Gibt die JSON-Repräsentation des contents zurück 
 */
	function accountsettings_content() {
		global $accountmanager,$textmanager,$navigationmanager;
		$text = $textmanager->translate();
		$user = $accountmanager->get_user();
		
		$json = array('content' => array(array("type" => "title", "text" => $text->accountset->title)
										,array("type" => "form",
											   'form' => array("title" => $text->forms->privbeb
															  ,"action"=> "accountsettings.php&op=save"
											 				  ,"klasse" => "center" #css class
											 				  ,"send" => $text->forms->save
											 				  ,"data" => array(array("type" => "view"
																					,"text" => $text->forms->name
											 				  						,"value" => $user->get_name())
																		 			,array("type" => "input"
																		 				  ,"text" => $text->forms->email
																		 				  ,"value" => $user->get_email()
																		 				  ,"id" => "email"
																		 				  ,"autocomplete" => "no")
																					,array("text" => $text->forms->pass
																						  ,"type" => "password"
																						  ,"id" => "password"
																						  ,"autocomplete" => "new-password")
																					,array("text" => $text->forms->passbes
																						  ,"type" => "password"
																						  ,"autocomplete" => "new-password"
																						  ,"id" => "password2")
																				)
																))
		));
		$json['navigation'][] = $navigationmanager->addnav($text->navigation->home,"index.php");
		$json['navigation'][] = $navigationmanager->addnav($text->navigation->about,"about.php");
		$json['navigation'][] = $navigationmanager->addnav($text->navigation->media,"media.php");		

		$navigationmanager->addnav("","accountsettings.php&op=save");
		$json = json_encode($json);
		return $json;		
	}
	/**
	 *  Speichert nach abesnden des formulares geänderte daten und leitet auf @link home.php weiter
	 */
	function accountsettings_operation_save() {
		global $accountmanager,$SETTINGS,$textmanager,$navigationmanager;
		$text = $textmanager->translate();
		
		//array bauen 
		$update_keys = array('email');
		$update_value = array($_POST['email']);
		//passwort update?
		if (!empty($_POST['password']) && !empty($_POST['password2'])) {
			if (!($_POST['password'] != $_POST['password2']) || strlen($_POST['password']) < 3) {
				$update_keys[] = "passwort";
				$update_value[] = $_POST['password'];				
			}	
		}
		if ($accountmanager->update_user($update_keys, $update_value)) {
			$navigationmanager->redirect('home.php');
		}
		
	}
?>