<?php
/**
 * Generiert Content bei zugriff auf impressum.php
 */

/**
 * Beim aufruf der datei wird standartmässig die funktion about_content aufgerufen,
 * sofern "op" am link angehangen wird wird die entsprechende operation ausgeführt
 * @package     content
 * @author      Stefan Meyer
 * @version     v.0.9
 * @copyright   Copyright (c) 2018, Stefan
 */

/**
 * Generiert den standartcontent beim about aufruf
 * @return string $json Gibt die JSON-Repräsentation des contents zurück
 */
function impressum_content() {
	global $accountmanager,$textmanager,$navigationmanager;
	$text = $textmanager->translate();
	$user = $accountmanager->get_user();

	$tout['content'] = array(array("type" => "title",
			"text" => $text->impressum->title),
			array("text" => $text->impressum->content,
					"type" => "text")
	);

	$tout['navigation'][] = $navigationmanager->addnav($text->navigation->home,"index.php");
	$tout['navigation'][] = $navigationmanager->addnav($text->navigation->about,"about.php");
	$tout['navigation'][] = $navigationmanager->addnav($text->navigation->media,"media.php");
	if (!$user) $tout['navigation'][] = $navigationmanager->addnav($text->navigation->register,"index.php&op=create");

	$json = json_encode($tout);
	return $json;
}