<?php
/**
 * Generiert Content bei zugriff auf den index
 */

/**
 * Beim aufruf der datei wird standartmässig die funktion index_kontent aufgerufen, 
 * sofern "op" am link angehangen wird wird die entsprechende operation ausgeführt
 * @package     content
 * @author      Stefan Meyer
 * @version     v.0.9 
 * @copyright   Copyright (c) 2018, Stefan 
 */

/**
 * Generiert den standartcontent beim index aufruf
 * @return string $json Gibt die JSON-Repräsentation des contents zurück 
 */
	function index_content() {
		global $accountmanager,$_POST,$_GET,$textmanager,$navigationmanager;
		$text = $textmanager->translate();
		//ist jemand eingelogt?
		if($accountmanager->is_loggedin()) {
			$navigationmanager->redirect('home.php');
		}else{
			$tout['content'] = array(array("type" => "title",
										   "text" => $text->index->title)
									,array("text" => $text->index->content,
										   "type" => "text")
					            	 );
			$tout['navigation'][] = $navigationmanager->addnav($text->navigation->home,"index.php");
			$tout['navigation'][] = $navigationmanager->addnav($text->navigation->about,"about.php");
			$tout['navigation'][] = $navigationmanager->addnav($text->navigation->media,"media.php");
			$tout['navigation'][] = $navigationmanager->addnav($text->navigation->register,"index.php&op=create");
		}	
		if (isset($_GET['info'])) {
			switch ($_GET['info']) {
				case 1:
					$tout['note'] = array('type' => 'note',
							'text' =>$text->errors->sessiondestroy);
				break;
			}	
		}
		$json = json_encode($tout);
		return $json;
	}
	/**
	 * Generiert Content für die accounterstellung
	 * @return string $json Gibt die JSON-Repräsentation des contents zurück
	 */
	function index_operation_create() {
		global $textmanager;
		$text = $textmanager->translate();
		$tout['content'] = array(array("type" => "form",
											  'form' => array("title" => $text->forms->erstellentitle
															 ,"action"=> "index.php&op=register"
											 				 ,"klasse" => "center" #css class
											 				 ,"send" => $text->forms->registrieren
											 				 ,"data" => array(array("type" => "input"
																					,"text" => $text->forms->name
																					,"id" => "name"
																					,"autocomplete" => "username")
																		 			,array("type" => "input"
																		 				  ,"text" => $text->forms->email
																		 				  ,"id" => "email"
																		 				  ,"autocomplete" => "email"
																		 				)
																					,array("text" => $text->forms->pass
																						  ,"type" => "password"
																						  ,"id" => "password"
																						  ,"autocomplete" => "new-password"
																					)
																					,array("text" => $text->forms->passbes
																						  ,"type" => "password"
																						  ,"autocomplete" => "new-password"
																						  ,"id" => "password2")
															 				 		,array("text" => $text->forms->agb
															 				 				,"type" => "checkbox"
															 				 				,"checked" => ""
															 				 				,"value" => "agb"
															 				 				,"id" => "agb")
																				)
																)
											)
								);	
		$json = json_encode($tout);
		return $json;
	}
	/**
	 * Generiert Content für die registrierung.
	 * Überprüft die daten für die accounterstellung sofern  keinefehler auftretten leitet die funktion auf " @link home " weiter
	 * @return string $json Gibt die JSON-Repräsentation des contents zurück
	 */
	function index_operation_register() {
		global $accountmanager,$SETTINGS,$textmanager,$navigationmanager;
		$text = $textmanager->translate();
		
		if (!empty($_POST['name']) && !empty($_POST['password']) && !empty($_POST['password2']) && isset($_POST['agb'])) {
			if ($SETTINGS['minnamelenght'] < strlen(trim($_POST['name'])) && $SETTINGS['maxnamelenght'] > strlen(trim($_POST['name']))) {
				if(!$accountmanager->get_userdata($_POST['name'])) {
				//gültige emailadresse ?
					if (filter_var($_POST['email'], FILTER_VALIDATE_EMAIL)) {
						//email bereits bekannt ?
						if(!$accountmanager->get_userdata($_POST['email'])) {
							//passwort überprüfen
							if (!($_POST['password'] != $_POST['password2']) || strlen($_POST['password']) < 3) {
								//passwörter stimmen überein
								if (!empty($_POST['agb'])) {
									//alles super account erstellen
									$accountmanager->create_user($_POST['name'], $_POST['password'], $_POST['email']);
									$accountmanager->login($_POST['name'],$_POST['password']);
									$navigationmanager->redirect('home.php');
								}else{ // agb nicht akzeptiert
									
									$json = array('note' => array('type' => 'note',
												  'text' =>$text->errors->agb));	
								}
							}else{ //falsches passwort
								$json = array('note' => array('type' => 'note',
										'text' =>$text->errors->pw));
							}					
						}else{ //email bereits vorhanden
							$json = array('note' => array('type' => 'note',
										  'text' =>$text->errors->emailduplicate));
							
						}
					}else{ //ungültige emailadresse
						$json = array('note' => array('type' => 'note',
									  'text' =>$text->errors->emailfail));
						
					}
				}else{ # name bereits vergeben
					$json = array('note' => array('type' => 'note',
								'text' =>$text->errors->samename));
				}
			}else{
				$json = array('note' => array('type' => 'note',
							  'text' =>$text->errors->namelenght));			
			}
		}else{ //nicht alle felder ausgefüllt
			$json = array('note' => array('type' => 'note',
					      'text' =>$text->errors->nonrequiredfield));			
		}
		$json = json_encode($json);
		return $json;
	}
	/**
	 * Prüft ob die accountdaten übereinstimmen und leitet auf " @link home " weiter sofern sie stimmen ansonsten gibt es eine fehlermeldung
	 * @return string $json Gibt die JSON-Repräsentation des contents zurück
	 */
	function index_operation_login() {
		global $_POST,$accountmanager,$textmanager,$navigationmanager;
		$text = $textmanager->translate();
		//logindaten erhalten?
		if (!empty($_POST['name']) && !empty($_POST['password'])) {
			//user einloggen
			if ($accountmanager->login($_POST['name'],$_POST['password'])) {
				//login erfolgreich
				$navigationmanager->redirect('home.php');
			}else{
				//login fehlgeschlagen
				$json = array('note' => array('type' => 'note',
						'text' =>$text->errors->faillogin));
					
					
			}
		}else{
			$json = array('note' => array('type' => 'note',
					'text' =>$text->errors->faillogin));
		}
		$json = json_encode($json);
		return $json;
	}
	/**
	 * Logt einen eingelogten user aus und leitet auf  " @link index " weiter
	 */
	function index_operation_logout() {
		global $accountmanager,$navigationmanager;
		$accountmanager->logout();
		$navigationmanager->redirect('index.php');
	}
?>