<?php
/**
 * Stellt Funktionen und logik zur Account/user Verwaltung bereit 
 */
/**
 * Speichert den loginstatus des aktuell in $user gespeicherten /user s sowie den user selber.
 * @package     controller
 * @author      Stefan Meyer
 * @version     v.0.9 
 * @copyright   Copyright (c) 2018, Stefan  
 */
class accountmanager {
	/**
	 * @var user $user Speichert das User obj welches gerade eingelogt ist
	 */
	private $user; 
	/**
	 * @var bool $loggedin true wenn ein user eingelogt ist
	 */
	private $loggedin = false;
	//TODO auslagern in settings
	/**
	* @var array $secure_accdata [Feldname=>bool] besonders geschütze accountdaten
	*/
	private $secure_accdata = array('passwort' => true,
									'email' => true);
	/**
	 *  setzt sofern vorhanden aus der session den /user oder false sofern userdaten vorhanden sidn wird loggedin auf true gesetzt 
	 */
	function __construct() {
		global $persistencemanager;
		//userdata vorhanden?
		$this->user = $persistencemanager->get_user_session();
		if ($this->user === false) {
			//keine userdaten - kein account eingelogt
			
		}else{
			$this->loggedin = true;
		}
	}
	/**
	 * Sucht nach dem User $name prüft das Passwort.
	 * Setzt $this->loggedin auf true
	 * speichert eingelogten user in $this->user 
	 * @param String $name name des einzuloggenden Users
	 * @param String $pass passwort im klartext des einzuloggendem users
	 * @return boolean true wenn user gefunden wurde False wenn nicht
	 */
	function login($name,$pass) {
		global $persistencemanager;
		$user_arr = $this->get_userdata($name);
		if ($user_arr === false) return false;
		if (password_verify($pass, $user_arr['passwort'])) {
			//user einloggen
			$this->user = new user($user_arr);
			$persistencemanager->set_user_session($this->user);
			$this->loggedin = true;
			return true;
		}// falsche userdaten
		return false;
	}
	/**
	 * Logt den aktuell eingelogten User aus
	 * Zerstört die Session
	 * setzt Loggedin auf false
	 */
	function logout() {
		global $persistencemanager;
		$this->loggedin = false;
		$persistencemanager->destroy_user_session();
	}
	
	/**
	 * Prüft ob ein User eingelogt ist
	 * @return boolean true/false
	 */
	function is_loggedin() {
		if ($this->loggedin) return true;
		return false;
	}
	
	/**
	 * Sucht anhand von identifier einen User
	 * @param mixed $identifier name email oder id des zu suchendem users
	 * @return /user oder false
	 */
	function get_userdata($identifier) {
		global $persistencemanager;
		//suchen per ID
		if (is_numeric($identifier)) {
			$user_arr = $persistencemanager->get_user_by_id($identifier);
		}elseif(strpos($identifier, "@") > 0) {
			$user_arr = $persistencemanager->get_user_by_email($identifier);	
		}else{
			$user_arr = $persistencemanager->get_user_by_name($identifier);	
		}
		if (empty($user_arr)) return false;
		return $user_arr;
	}
	/** 
	 * Erstellt ein User obj und speichert diesen 
	 * @param string $name name des Users
	 * @param String $pw passwort des users im klartext
	 * @param string $email email des zu erstellendem users
	 */
	function create_user($name,$pw,$email) {
		global $persistencemanager;
		$name = trim(strip_tags($name)); 
		$pw = password_hash($pw, PASSWORD_DEFAULT);
		$email = trim(strip_tags($email));
		$user = new user(array('name' => $name, 'passwort' => $pw, 'email' => $email, 'id' => -1));
		$persistencemanager->save_data('user',-1,$user);
	}
	/** 
	 * Ändert Werte am User obj speichert die änderungen. 
	 * @param array $key_arr  enthält die schlüsselpaare
	 * @param array $value_arr  enthält die wertpaare zum schlüssel
	 */
	function update_user($key_arr, $value_arr) {
		foreach ($key_arr AS $key => $value) {
			if (in_array($value,$this->secure_accdata)) {
				$f = "set_".$value;
				if (method_exists($this->user,"set_".$value)) {
					if(!$this->user->$f($value_arr[$key])) {
						return false;
					}					
				}else{					
					return false;
				}
			}
		}
		$this->saveuser($this->user);
		return true;
	}
	/**
	 * Speichert ein user obj in der persitence 
	 * @param /user $user_obj das zu speichernde Userobject
	 */
	function saveuser($user_obj) {
		global $persistencemanager;
		$persistencemanager->save_data('user',$user_obj->get_id(),$user_obj);
	}	
	//getter and setter
	/**
	 * gibt den aktuellen user zurück
	 * @return user /user
	 */
	function get_user() {
		return $this->user;
	}

}



?>