<?php
/**
 * Generiert und verwaltet den Content
 */
/**
 * Ermittelt die benötigte Sprache und läd die entsprechende sprache liest die Content datein aus und wandelt deren Inhalt in einen JSON string für den Client weiter
 * @package     controller
 * @author      Stefan Meyer
 * @version     v.0.9 
 * @copyright   Copyright (c) 2018, Stefan   
 */
class contentmanager {
	/**
	 * @var string $content Content im json format
	 */
	private $content;
	/**
	 * @var string $lng Sprachstring
	 */	
	private $lng;
	/**
	 * @var bool $userloggedin Speichert den loginzustand des users
	 */	
	private $userloggedin; //TODO wirklich sinnvoll?! ehr nicht besser "live" abfragen
	/**
	 * Textmenager Object initallisieren und sprachobjekt in $lng speichern
	 */
	function __construct() {
		global $textmanager, $accountmanager;	
		$textmanager = new textmanager($this->get_preferred_language());
		$this->lng = $textmanager->translate();
		$this->userloggedin = $accountmanager->is_loggedin();
		
	}
	/**
	 * ermittelt den Sprachcode anhand des Servers, der Einstellungsmöglichkeit, speichert änderungen der Sprache im user sofern eingelogt oder der Usereinstellungen sofern eingelogt 
	 * @return string Sprachcode
	 */
	function get_preferred_language() {
		global $accountmanager,$persistencemanager;
		
		if (!empty($_GET['cl'])) {
			//usersprache updaten wenn eingelogt
			if($accountmanager->is_loggedin()) {
				//TODO sicherheitscheck
				$user = $accountmanager->get_user();
				if ($user->get_lang() != $_GET['cl']) {
					$user->set_lang($_GET['cl']);
				}
			}
			$persistencemanager->add_session(array('lng' => $_GET['cl']));
			return $_GET['cl'];
		}elseif ($accountmanager->is_loggedin()) {
			$user = $accountmanager->get_user();
			$persistencemanager->add_session(array('lng' => $user->get_lang()));
			return $user->get_lang();
		}else{
			$session = $persistencemanager->get_session();
			if (isset($session['lng'])){
				return $session['lng'];
			}
		}
		//Sprache ermitteln
		$acceptedLanguages = @explode(',', $_SERVER['HTTP_ACCEPT_LANGUAGE']);
		$preferredLanguage = null;
		$maxWeight = 0.0;
		foreach($acceptedLanguages as $acceptedLanguage){
			$weight = (float)@substr(explode(';', $acceptedLanguage)[1], 2);
			if(!$weight){
				$weight = 1.0;
			}
			if($weight > $maxWeight){
				$preferredLanguage =  substr($acceptedLanguage, 0, 2);
				$maxWeight = $weight;
			}
		}
		$persistencemanager->add_session(array('lng' => $preferredLanguage));
		return $preferredLanguage; 
	}	
	/** Liest die Content datei aus und speichert ein JSON string in $this->content der die inhaltsinformationen bereithält
	 *  
	 * @param string $content enthält den dateinamen und optionen default.php&op=whatver
	 */
	function generate_content($content) {
		global $SETTINGS,$accountmanager,$navigationmanager,$textmanager;
		$text = $textmanager->translate();
		//TODO zugriffsrechte "manipulation" einschränken "addnav" ( in require)
				
		//handle content
		//optionen splitten
		$pos = strpos($content, "?");
		if ($pos > 0) {	
			$schwaenzchen = explode("?", $content);
		}//garkein anhang garnix machen ;)
		//zugriff auf interen Seiten verweigern
		if (!array_key_exists((isset($schwaenzchen[0]) ? $schwaenzchen[0] : $content),$SETTINGS['whitelist'])) {
			//zugriffsbeschränkung spieler eingelogt ?
			if(!$accountmanager->is_loggedin()) {
				//keine zugriffsrechte - redirect zu index
				$navigationmanager->redirect($SETTINGS['defaultsite'].$SETTINGS['sessioninfocode']);
			}	
		}
		//content datei einbinden
		//pfad anpassen 
		$pfad = substr(__DIR__,0,-10);
		
		require_once $pfad."content\\".(isset($schwaenzchen[0]) ? $schwaenzchen[0] : $content);
		//content einlesen
		//TODO mach kommsiche dinge mit op go go
		if (!empty($_GET['op'])) {
			$modulname =  substr($schwaenzchen[0],0,-4);
			$f = $modulname."_operation_".$_GET['op']."";
			$tout = $f();
		}else{
			$modulname =  substr((isset($schwaenzchen[0]) ? $schwaenzchen[0] : $content),0,-4);
			$f = $modulname."_content";
			$tout = $f();	
		}
		//userinformationen mitsenden sofern vorhanden
		$tout = json_decode($tout, true);
		if ($accountmanager->is_loggedin()) {
			//hinzufügen von userdaten
			$tout['userinfo'] = $accountmanager->get_user()->jsonSerialize();
		}else{
			//loginmöglichkeit anbieten
			$tout['login'] = array(array("type" => "form",
										 'form' => array("title" => $text->forms->logintitle
														 ,"action"=> "index.php&op=login"
														 ,"klasse" => "center" #css class
														 ,"send" => $text->forms->login
														 ,"data" => array(array("type" => "input"
																			   ,"text" => $text->forms->name
																			   ,"id" => "name"
																			   ,"autocomplete" => "username")
																		  ,array("text" => $text->forms->pass
																				,"type" => "password"
																				,"id" => "password"
																				,"autocomplete" => "current-password"
																				)
																		  )
														 )
									      )
							        );
			$tout['userinfo'] = false;
		}
		//basis navigation hinzufügen
		$basicnav = $navigationmanager->basic_loginnav();
		if ($basicnav) $tout['navigation'] = array_merge($tout['navigation'], $basicnav);
		//footer informationen anhängen
		//TODO auslagern
		$tout['footer'][] = $navigationmanager->addnav($text->navigation->impressum,"impressum.php",'footer');
		$tout['footer'][] = $navigationmanager->addnav($text->navigation->doc,"doc/index.html",'footer_ext');
		$tout['footer'][] = $navigationmanager->addnav($text->navigation->dummy,"#",'footer');
		$tout['footer'][] = $navigationmanager->addnav($text->navigation->dummy,"#",'footer');
		$tout['footer'][] = $navigationmanager->addnav($text->navigation->dummy,"#",'footer');
		//TODO data array auslagern (settings ?!)
		$tout['footer'][] = array("type"=>"lang" ,"data" => array('de','en'),'select' => $this->get_preferred_language());
		$tout = json_encode($tout);
		$this->set_content($tout);
	}
	
	//getter und setter
	/** Gibt den aktuellen Content aus
	 * @return string Content im json format
	 */
	function get_content() {
		return $this->content;
	}
	/**
	 * Speichert den content
	 * @param string $content im json format
	 */
	function set_content($content) {
		$this->content = $content;
	}	
	
}