<?php
/**
 * Stellt und Verwaltet die angezeigte Navigation
 */


/**
 * Fügt navigationsoptionen zum JSON ausgbaestring ein.
 * Sorgt dafür das bestimmte Seiten nicht angezeigt werden wenn die Zugriffsrechte nicht vorhanden sind 
 * @package     controller
 * @author      Stefan Meyer
 * @version     v.0.9 
 * @copyright   Copyright (c) 2018, Stefan  
 */
class navigationmanager {
	/**
	 * @var array $allowednav zulässige Navigation
	 */
	private $allowednav = array();
	/**
	 * @var array $whitelist datein die von der zugriffskontrolle ausgenommen sind
	 */
	private $whitelist =array();
	/**
	 * Läd die liste aus den eisntellungen welcher Content auch ohne eingelogt zu sein angezeigt werden dürfen.
	 */
	function __construct() {
		global $SETTINGS;
		$this -> whitelist = $SETTINGS['whitelist'];
	}
	/**
	 * Fügt einen navigationslink hinzu
	 * @param string $title Name des Links
	 * @param string $link URl des links
	 * @param string $menue type des links footer/menuenav/nav
	 * @return array $json gibt ein array mit den link informationen zurück
	 */
	function addnav($title,$link,$menue = false) {
		$json ='';
		if ($link > ' ') {
			//füge zur erlaubten navigation zu
			$this->allowednav[$link] = true;
		}
		//gib Json zurück
		//baue JSON
		if ($title > ' ') {
			$json = array("type"=>"".($menue ? $menue:"nav")."" ,"text" => $title, "url" => $link);
		}
		return $json;	
	}
	/** leitet direkt auf eine andere seite weiter speichert aktuelle usersession zwischen
	 * 
	 * @param string $location ziel der weiterleitung (url)
	 */
	function redirect($location) {
		global $persistencemanager;
		if (isset($_GET['debug'])) {
			$url = "main.php?debug=1&s=".$location;
		}else{
			$url = "main.php?s=".$location;
		}
		$persistencemanager->save_user_session();
		$persistencemanager->save_session();
		@header("Location: $url");
		exit();
	}
	/**
	 * Definiert die basis Navigation fürs Menü wenn man eingeloggt ist.
	 * @return array|bool gibt ein array zurück sofern navigation vorhanden ist sonst false
	 */
	function basic_loginnav() {
		global $accountmanager,$textmanager,$navigationmanager;
		$text = $textmanager->translate();
		$user = $accountmanager->get_user();		
		if ($user) {
			$json[] = $navigationmanager->addnav($text->navigation->profiledit,"accountsettings.php",'menuenav');
			$json[] = $navigationmanager->addnav($text->navigation->logout,"index.php&op=logout",'menuenav');
		}else{
			$json = false;
		}
		return $json;
	}

}