<?php
/**
 * Stellt Funktionen zur textanzeige bereit 
 * 
 * Läd die sprachdatei anhand des übergebenen parameters $language.
 */
/**
 *  Läd die Sprachdatei und stellt diese zur verfügung.
 *  Zeigt den json string lesbar an, im debugmodus
 * @package     controller
 * @author      Stefan Meyer
 * @version     v.0.9 
 * @copyright   Copyright (c) 2018, Stefan  
 */
class textmanager {
	/** 
	 * @var string $data enthält die Sprachstrings des Json objekts der jeweiligen Sprachdatei
	 */
	private $data;
	/**
	 * Läd die sprachdatei anhand des sprachcodes in $language
	 * @param string $language enthält den Sprachcode
	 */
	function __construct($language) {
		global $persistencemanager;
		$this->data = $persistencemanager->get_data('msg',$language,false);
	}
	/**
	 * stellt das sprachobjekt zur verfügung
	 * @return string Spachrobjekt
	 */
	function translate() {
		return $this->data;
	}
	/**
	 * Wandelt das JSON content objekt in anzeigbaren code um
	 * @param string $json enthält den Contentstring
	 * @return gibt die komplette webseite in html code zurück
	 */
	function beautiful_debug_text($json) {
		$json_decode = json_decode($json,true);
		$tout =array('header' => 'DEBUGMODUS: header'
					,'nav' =>'navigation'
					,'note'=> 'hinweistexte'
					,'content' => 'content'
					,'login' => ""
					,'footer' => 'footer<br>'.$json);
		//splitten in Header footer content nav und notes
		if ($json_decode) {
			foreach($json_decode AS $key => $value) {
				switch($key) {
					case 'header':
						$tout['header'] = "DEBUGMODUS: ".$this->create_beautiful_text($value);
					break;
					case 'navigation':
						$tmp = '';
						foreach ($value AS $k => $data) {
							$tmp .= $this->create_beautiful_text($data);
						}
						$tout['nav'] =  $tmp;
					break;
					case 'note':
						$tout['note'] = $this->create_beautiful_text($value);
					break;
					case 'content':
						$tmp = '';
						foreach ($value AS $k => $data) {
							$tmp .= $this->create_beautiful_text($data);
						}
						$tout['content'] = $tmp;
					break;
					case 'login':
						$tmp = '';
						foreach ($value AS $k => $data) {
							$tmp .= $this->create_beautiful_text($data);
						}
						$tout['login'] = $tmp;
					break;
					case 'footer':
						$tmp ='';
						foreach ($value AS $k => $data) {
							$tmp .= $this->create_beautiful_text($data);
						}
						$tout['footer'] = $tmp."<br><br>".$json;
					break;	
				}	
			}
		}
		return $this->beautiful_create_template($tout);
	}
	/**
	 * Helferfunktion zum umwandeln von verschiednene typen im content string
	 * @param string $data_arr json ausgangsarray
	 * @return string html code für die ausgabe
	 */
	function create_beautiful_text($data_arr) {	
		switch($data_arr['type']) {
			case "text":
				$content = "<p>".$data_arr['text']."</p>";
				break;
			case "note":
				$content =  "<p class=\"note_text\">".$data_arr['text']."</p>";
				break;
			case "title":
				$content =  "<p class=\"title\">".$data_arr['text']."</p>";
				break;
			case "nav":
			case "menuenav":
			case "footer":
				$content = "<li><a class=\"nav\" href=\"main.php?debug=1&s=".$data_arr['url']."\" onClick=\"navigate(event)\">(".$data_arr['type'].") ".$data_arr['text']."</a></li>";
				break;
			case "form":
				//daten aufsplitten
				$content = "<fieldset class=\"fieldset ".$data_arr['form']['klasse']."\"> <legend>".$data_arr['form']['title']."</legend>";
				$content .= "<form id =\"form\" name=\"".$data_arr['form']['action']."\" action=\"main.php?debug=1&s=".$data_arr['form']['action']."\" method=\"POST\" ><table>";
				//typen felder einfügen
				foreach($data_arr['form']['data'] AS $key => $value) {
					switch ($value['type']) {
						case "input":
							$content .="<tr><td><label><small>".$value['text'].": </small></label></td><td><input type=\"text\" id = \"input_".$value['id']."\" name=\"".$value['id']."\" value=\"".(empty($value['value']) ? "": $value['value'])."\"/ autocomplete=".$value['autocomplete']."></td></tr>";
							break;
						case "password":
							$content .="<tr><td><label><small>".$value['text'].": </small></label></td><td><input type=\"password\" id = \"input_".$value['id']."\" name=\"".$value['id']."\" autocomplete=\"".$value['autocomplete']."\"></td></tr>";
							break;
						case "checkbox":
							$content .="<tr><td><label><small>".$value['text'].": </small></label></td><td><input type=\"checkbox\" id = \"input_".$value['id']."\" name=\"".$value['value']."\" value=\"".$value['value']."\"".$value['checked']."\"></td></tr>";
						break;
						case "view":
							$content .="<tr><td><label><small>".$value['text'].": </small></label></td><td>".$value['value']."</td></tr>";
							
					}
				}
				$content .= "<tr><td></td><td><button>".$data_arr['form']['send']."</button></td></tr></form>";
				$content .= "</form></table></fieldset>";
			break;
			default; 
				$content = $data_arr['type']."nicht gefunden!";
		}
		return $content;
	}
	/**
	 * Stellt das basis template zur verfügung und fügt die einzelenen Inhalte ins template ein
	 * @param array $input_arr die inhalte als array
	 */
	function beautiful_create_template($input_arr) {
	$tout ='<!doctype html>
				<html>
				<head>
				<meta charset="utf-8">
				<title></title>
				<link href="./templates/default.css" rel="stylesheet" type="text/css">
				</head>
				<body>
				
				<div class="container">
				<div class="header" id="header">
					'.$input_arr['header'].'
				<!-- end .header --></div>
				<div class="sidebar1">
				<ul class="nav" id="nav">
				'.$input_arr['nav'].'
				<li class="title">Debugnav</li>
				<li><a class="nav" href="main.php?debug=1&s='.$_GET["s"].'" onClick="navigate(event)">Default site</a></li>
				</ul>
				<!-- end .sidebar1 --></div>
				<div class="note" id="note">'.$input_arr['note'].'</div>
				<div class="content" id="content">
				'.$input_arr['content'].'
				<!-- end .content --></div>
				<div class="footer" id="footer">
				'.$input_arr['login'].'		
				'.$input_arr['footer'].'
						
				<!-- end .footer --></div>
				<!-- end .container --></div>
				</body>
				</html>';
		return $tout;
	}	
}

?>

