<?php
/**
 *  Main - Zentrale verwaltung
 * @package     root
 * @author      Stefan Meyer
 * @version     v.0.9 
 * @copyright   Copyright (c) 2018, Stefan   
 */
/**
 * Bindet alle benötigten Klassen und Objekte ein, verbindet den Userzugriff mit den Controleren und gibt den generierten Content aus. 
 */
require_once __DIR__.'/data/settings.php'; #$SETTINGS

//debugmodus verbieten?
if($SETTINGS['debugmode'] === false) unset($_GET['debug']);

//einbinden der model
require_once __DIR__.'/valueobjects/user.php';

//einbinden der Controller
require_once __DIR__.'/controller/textmanager.php';
require_once __DIR__.'/controller/accountmanager.php';
require_once __DIR__.'/controller/contentmanager.php';
require_once __DIR__.'/controller/navigationmanager.php';
//persistence einbinden
require_once __DIR__.'/model/persistencemanager.php';
// Session starten
session_start();
//Speicherzugriffe
$persistencemanager = new persistencemanager($_SESSION);

//controller objekte erschaffen
$accountmanager = new accountmanager();
$contentmanager = new contentmanager();
$navigationmanager = new navigationmanager();

//sprachänderung abfangen
if (isset($_GET['cl'])) {	
	unset($_GET['cl']);
}

//generate Content
if (isset($_GET['s'])) {
	$url = $_GET['s'];
	$firsttime = true;
	//restliche "gets" anfügen
	foreach($_GET AS $key => $value) {
		if ($key != 's') {
			$url .=($firsttime ? "?": "&").$key."=".$value;
			$firsttime = false;
		}
	}
	$contentmanager->generate_content($url);	
}

if (!isset($_GET['debug'])) {
	print($contentmanager->get_content());
}else{	
	print($textmanager->beautiful_debug_text($contentmanager->get_content()));
}
$persistencemanager->save_user_session();
$persistencemanager->save_session();

session_write_close();
?>