<?php
/**
 * Stellt funktionen zum laden speichern und suchen in json datein zur verfügung
 */
/**
 * Speichert daten in textfiles und liest den inhalt nach bedarf wieder aus
 * @package     model
 * @author      Stefan Meyer
 * @version     v.0.9 
 * @copyright   Copyright (c) 2018, Stefan 
 */
class filepersistencemanager {
	/**
	 * 
	 * @var string Enthält den Pfad zum Dateisystem
	 */
	private $path;	
	/**
	 * Definiert den `Pfad zu den daten
	 */
	function __construct() {
		$this->path = substr(__DIR__,0,-6)."/data/"; //TODO in settings auslagern?
	}
	/**
	 * läd eine datei $from_$id aus dem Ordner $from und gibt deren inhalt als string zurück 
	 * @param string $from Ordername und erster part des filenames
	 * @param mixed $id eindeutige ID zur fileerkennung
	 * @return boolean|string false bei fehler sonst den inhalt der datei als string
	 */
	function get_data_from_file($from,$id) {
		if (!file_exists($this->path.$from."/".$from."_".$id.".json")) return false;
		$datei = fopen ($this->path.$from."/".$from."_".$id.".json", "r");
		if (!$datei) {
			return false;
		}
		$data ='';
		while (!feof ($datei)) {
			$zeile = fgets ($datei, 1024);
			$data .=$zeile;
		}		
		fclose($datei);	
		return $data;
	}
	/**
	 * speichert data eine datei $from_$id in dem Ordner $from
	 * @param string $from Ordername und erster part des filenames
	 * @param mixed $id eindeutige ID zur fileerkennung
	 * @param string data der zu speichernde string im json format
	 */
	function save_data_to_file($from,$id,$data) {
		$datei = fopen($this->path.$from."/".$from."_".$id.".json","w+");
		fwrite($datei, $data);
		fclose($datei);
	}
	/**
	 * Zählt die bereits vorhandenen Daten und gibt die anzahl der datein zurück
	 * @param string $from Ordername
	 * @return number die nächste freie ID
	 */
	function get_next_id($from) {
		$path = $this->path.$from;
		$handle = opendir($path);
		$i = 1;
		while ($file = readdir($handle)) {	
			if($file != "." AND $file != "..") {	
				$i++;			
			}
		}
		closedir($handle);	
		return $i+1;
	}
	/**
	 * Durchsucht alle datein aus $from nach einem $key mit passendem $value und gibt die ID zurück
	 * @param string $from Ordername
	 * @param mixed $key key des zu suchenden wertes
	 * @param mixed $value der zu suchende wert
	 * @return number id
	 */
	function search_in_file($from,$key,$value) {
		$maxid = $this->get_next_id($from)-1;
		$i=0;
		while ($i <= $maxid) {
			$data = json_decode($this->get_data_from_file($from, $i),true);
			if (!empty($data[$key])) {
				if($data[$key] == $value) {
					return $i;
				}
			}
			$i++;
		}		
	}
	
	
	
}


?>