<?php
/**
 * Verwaltet Speicherzugriffe
 */
/**
 * Verteilt Speicherzugriffe auf das Fiesystem oder datenbanksystem, läd die entsprechenden daten und gibt diese zurück, oder speichert die Daten. 
 * @package     model
 * @author      Stefan Meyer
 * @version     v.0.9 
 * @copyright   Copyright (c) 2018, Stefan 
 */
class persistencemanager {

	//private $db_manager = "";
	/**
	 * @var $file_manager zugriff auf Dateispeicherungen
	 */
	private $file_manager = "";
	/** 
	 * @var array $session Session
	 */
	private $session = array();
	/**
	 * @var array $in_file gibt an welche datein in files liegen. ( wird erst im zusammenspiel mit der datenbank sinnvoll)
	 */	
	private $in_file = array();
	/**
	 * initallisiert die zugriffstypen (File,datenbank) lad aus den Settings die Konfiguration für File und Datenbankzugriff und speichert die Session zwischen
	 * prüft ob die usersession nach updates aktuallisert werden muss(todo)
	 */
	function __construct() {
		global $SETTINGS,$_SESSION;
		//TODO erstelle Datenobjekte
		//require_once 'dbpersistencemanager.php';
		require_once 'filepersistencemanager.php';
		//$this->db_manager = new dbpersistencemanager('user','pass','host','name');
		$this->file_manager = new filepersistencemanager();
		$this->in_file = $SETTINGS['in_file'];
		$this->session = $_SESSION;
		//userdaten in der sesion ?
		if (!empty($this->session['user'])) {
			//TODO checken ob daten aktuallisert werden müssen
			
		}else{
			$this->session['user'] = false;
		}		
	}
	/**
	 * Läd einen JSON/whatever string aus einem File/whatever und gibt dieses als array zurück
	 * @param string $data_class typ der abzufragenden daten 
	 * @param  $getdata ---
	 * @param bool $asarray ruckgabe als array oder nicht 
	 */
	function get_data($data_class,$getdata,$asarray = true) {
		
		if (in_array($data_class,$this->in_file)) {
			//datei aus einem file auslesen
			$data = $this->file_manager->get_data_from_file($data_class,$getdata);
			if ($data) {
				return json_decode($data,$asarray);
			} 
		}else{
			//TODO Datenbank befragung
		}
	}
	/** 
	 * Speichert daten eines Objects $data_obj objekt benötigt jsonSerialize()
	 * 
	 * @param string $from
	 * @param mixed $id
	 * @param mixed $data_obj benötigt jsonSerialize()
	 */
	function save_data($from,$id = -1,$data_obj){ //TODO change typ to obj
		if ($id == -1) {
			//neuer datensatz
			if (in_array($from,$this->in_file)) {
				$id = $this->file_manager->get_next_id($from);
				if (method_exists ($data_obj, 'set_id')) {
					$data_obj->set_id($id);
				}
				//objekt in json verträglcihes array umwandeln
				$data_obj = $data_obj->jsonSerialize();
			}else{
				//TODO get last id DB return $id
				
			}
		}else{
			//nur file
			//objekt in json verträgliches array umwandeln
			$data_obj = $data_obj->jsonSerialize();
			//alte daten suchen
			$old_data = $this->get_data($from,$id);
			if ($old_data) {
				$data_obj = array_merge($old_data, $data_obj);
			}
		}
		if (in_array($from,$this->in_file)) {
			$data_obj['id'] = $id;
			$this->file_manager->save_data_to_file($from, $id, json_encode($data_obj));	
		}else{
			//TODO daten speichern
		
		}	
	}
	/**
	 * Sucht anhand des names nach einem /user
	 * @param string $name
	 * @return /user
	 */	
	function get_user_by_name($name) {		
		$id = $this->file_manager->search_in_file('user','name',$name);		
		return $this->get_data('user',$id);
	}
	/**
	 * Sucht anhand der Email nach einem /user
	 * @param string $email
	 * @return /user
	 */
	function get_user_by_email($email) {
		$id = $this->file_manager->search_in_file('user','email',$email);
		return $this->get_data('user',$id);
	}
	/**
	 * Sucht anhand der id nach einem /user
	 * @param int $id 
	 * @return /user
	 */
	function get_user_by_id($id) {
		return $this->get_data('user',$id);
	}	
	/**
	 * Gibt daten aus der Usersession zurück
	 * @param string $key
	 */
	function get_user_session() {
		return $this->session['user'];
	}
	/**
	 * speichert daten in der Usersession
	 * @param array $user 
	 */
	function set_user_session($user) {
		
		$this->session['user'] = $user;
	}
	/**
	 * speichert die daten des aktuellen users in der serversession
	 */	
	function save_user_session() {
		global $_SESSION;
		if ($this->session['user'] !== false) {
			$_SESSION['user'] = $this->session['user'];
		}
	}
	/**
	 * überschreibt die aktuellen user sessions
	 */	
	function destroy_user_session() {
		$_SESSION['user'] = false;
		$this->session['user'] = false;
	}
	function get_session() {
		return $this->session;
	}
	function set_session($arr) {
		$this->session = $arr;
	}
	function add_session($arr) {
		$this->session = array_merge($this->session,$arr);
	}
	function save_session() {
		$_SESSION = $this->session;
	}

}

?>