<?php
/**
 *  Userobjekt
 */
/**
 * Stellt die Userklasse zur verfügung
 * @package     valueobjects
 * @author      Stefan Meyer
 * @version     v.0.9
 * @copyright   Copyright (c) 2018, Stefan
 */
class user {
	/**
	 * Speichert den Usernamen
	 * @var string $name
	 */
	private $name;
	/**
	 * Spsichert das Passwort des Users als hash 
	 * @var string $passwort
	 */
	private $passwort;
	/**
	 * Speichert die email
	 * @var string $email
	 */
	private $email;
	/**
	 * Speichert den sprachcode
	 * @var string $lang
	 */
	private $lang;
	/**
	 * speichert die interne Accountid
	 * @var int $id
	 */
	private $id;
	/**
	 * Legt ein Userobjekt an
	 * @param string|int $user_arr
	 */
	function __construct($user_arr) {
		$this->name = $user_arr['name'];
		$this->passwort = $user_arr['passwort'];
		$this->email = $user_arr['email'];
		$this->id = $user_arr['id'];
		//optimal
		if (!empty($user_arr['lang'])) {
			$this->lang = $user_arr['lang'];	
		}else{
			$this->lang = 'de';
		}
	}
	/**
	 * Überprüft ob eine emailadresse valide ist und trägt diese ins Userobject ein
	 * @param string $email die neue emailadressse
	 * @return boolean true wenn erfolgreich sonst false
	 */
	function set_email($email) {
		//TODO verify email
		$this->email = $email;
		
		return true;
	}
	/**
	 * Setzt ein neuen passsworthash
	 * @param string $pass der neue passworthash
	 * @return boolean true wenn erfolgreich sonst false
	 */
	function set_passwort($pass) {
	
		$this->passwort = $pass;
	
		return true;
	}	
	/**
	 * Gibt den namen zurück
	 * @return string $name
	 */
	function get_name() {
		return $this->name;
	}
	/**
	 * Gibt den passworthash zurück
	 * @return string $passwort
	 */	
	function get_passwort() {
		return $this->passwort;
	}
	/**
	 * Gibt die email zurück
	 * @return string $email
	 */	
	function get_email() {
		return $this->email;
	}
	/**
	 * Gibt den sprachcode zurück
	 * @return string $email
	 */	
	function get_lang() {
		return $this->lang;
	}
	/**
	 * Gibt die userid zurück
	 * @return int $id
	 */
	function get_id() {
		return $this->id;
	}
	/**
	 * setzt die userid
	 * @param int $id
	 */
	function set_id($id) {
		$this->id = $id;
	}
	/**
	 * setzt die sprache
	 * @param string $c
	 */
	function set_lang($c) {
		$this->lang = $c;
	}
	/**
	 * Gibt das object jsonvalidierbar zurück
	 * @return mixed 
	 */
    function jsonSerialize() {
       return ['name' => $this->name,
               'passwort' => $this->passwort,
       		   'email' => $this->email,
       		   'lang' => $this->lang,
            ];
    }
}

?>