<?php
	/* Funktionen zur Darstellung des Inhaltes*/
/*
 *Ersetzt im Template Platzhalter mit Inhalt
 *@param $titel titel der Website
*/
function page_header_template($titel = 'Newcomer') {
	global $template,$headscript,$header,$login_tmp;
	if (!isset($headscript)) $headscript ='';
	$header = "".$template['header'].""; 
	$header = str_replace("{title}",$titel,$header);
}
/*
 *Ersetzt im Template Platzhalter mit Inhalt gibt das veraenderte Template aus und beendet die Session
*/	
function page_footer_template() {
	global $nav,$tout,$mail,$template,$basic_nav,$headscript,$header,$login_tmp,$session,$_GET;
	$footer = "".$template['footer']."";
	$header = str_replace("{tmp_headerimage}",'template/newstyle/images/demo/468x60.gif',$header);
	$header = str_replace("{headskript}",$headscript,$header);
	$header = str_replace("{login}",$login_tmp,$header);	
	//navigations liste schliesen
	if (!empty($session['artist']['artistid'])) add_basic_nav('Profil','profil.php?artistid='.$session['artist']['artistid'].'');
	if (!empty($nav)) $nav = templatereplace("navmenue",array('navitems'=>"".$nav.""));
	$footer = str_replace("{basicnav}",$basic_nav,$footer);  
	$footer = str_replace("{nav}",$nav,$footer);
	//fehlermeldungen ausgeben
	if (isset($_GET['error'])) {
		$tout = urldecode($_GET['error']).$tout;
	}
	$footer = str_replace("{hfinhalt}",$tout,$footer);
	//template
	$footer = str_replace("{copyright}",' 2014 -newcommer-',$footer);
	$footer = str_replace("{version}",getsetting('version'),$footer);
	$session['output'] = $header.$footer;
	echo "".$session['output']."";
	$session['restorpage'] = basename($_SERVER['REQUEST_URI']);
	$_SESSION = $session;
	user_saveuser();
	session_write_close();		
}
/**
 * Ld das Basistemplate und gibt es zurck
 *
*/
function get_template() {
    global $session;
	#$templatename = 'basic.html';
	$templatename = '/newstyle/index.html';
    $fulltemplate = join("",file("template/".$templatename.""));
	$fulltemplate = explode("<!--!",$fulltemplate);
	
	while (list($key,$val)=each($fulltemplate)){
		$fieldname=substr($val,0,strpos($val,"-->"));
		if ($fieldname!=""){
			$template[$fieldname]=substr($val,strpos($val,"-->")+3);
		}
	}
	return $template;
}
/* Ersetzt einzellene Teile des templates
 *@param (string)$itemname das zu ersetzende Teil
 *@param (array) $vals -> platzhalten in einem Teil
*/
function templatereplace($itemname,$vals=false){
	global $template; 
	$out ='';
	@reset($vals);
	if (!isset($template[$itemname])){
		output_template("</br><b>Warnung: Das ".$itemname." Template wurde nicht gefunden!</b></br>");	
	}else{
		$out = $template[$itemname];
		while (list($key,$val)=@each($vals)){
				if (strpos($out,"{".$key."}")===false) output_template("</br><b>Warnung: Das ".$key." Teil wurde im ".$itemname." Template nicht gefunden!</b></br>");
				$out = str_replace("{".$key."}",$val,$out);
		}
	}
	return $out;
}


/**
 * Setzt text ins hauptfenster
 *@param (mixed) $inhalt der anzuzeigende Text als String oder als Array (nur templatereplace)
 *@param (templatekeyword) $templatereplace Schlsselwort frs template oder false (optimal)
*/
function output_template($inhalt,$templatereplace = false) {
	global $tout;
	//wenn wir direkt ins vorgefertigte Template "schreiben" wollen
	if ($templatereplace !== false) {	
		$tout .= "".templatereplace("".$templatereplace."",$inhalt)."";			
	}else{
		//normale Textausgabe
		$tout .= $inhalt;
	}
}
/**
 * Erstellt formular felder - gibt das fertige forumlar zurck
 *@param (array) $form enthlt den formularaufbau
 *@param (array) $data enthlt den inhalt der formulardaten - kann auch leer sein
 Format:
  key = feldname in data
  value = "beschreibung des feldes,FELDTYP,ATTRIBUT,WERT"
 
*/
function template_showform($form,$data,$newline = true) {
	$out = '';
	if(is_array($form)) {	
		foreach($form AS $key => $value) {
			$info = array();
			if (strpos($value, ',')) { $info = explode(',', $value);
				switch($info[1]) {
					case 'input':
						if (!isset($data[$key])) $data[$key] = '';
						$replace = array('id' => ''
										,'name' => ''.$key.''
										,'beschreibung' => ''.$info[0].''
										,'value' => ''.$data[$key].''
										,'class' => ''
										,'size' => '');
						if (array_search('type', $info) !== false) {
							$in = $info[array_search('type', $info)+1];
							if ($in == 'submit') {
								//senden butten sonderfall
								$replace['beschreibung'] = '';
								$replace['value'] = ''.$info[0].'';
							}
							$replace['type'] = $in;
						}else{
							$replace['type'] = $info[2];
						} 
						if (array_search('id', $info) !== false) $replace['id'] = $info[array_search('id', $info)+1];
						if (array_search('class', $info) !== false) $replace['class'] = $info[array_search('class', $info)+1];
						if (array_search('size', $info) !== false) $replace['size'] = $info[array_search('size', $info)+1];
						$out .= "".($newline === true ? '<tr>':'')."".templatereplace('input', $replace)."".($newline === true ? '</tr>':'')."";
					break;
					case 'textarea':
 						if (!isset($data[$key])) $data[$key] = '';
						$replace = array('id' => ''
										,'name' => ''.$key.''
										,'beschreibung' => ''.$info[0].''
										,'comment' => ''.$data[$key].''
										,'class' => ''
										,'cols' => 'cols ="100" '
										,'rows' => 'rows = "10" '
										);
						if (array_search('type', $info) !== false) $replace['type'] = $info[array_search('type', $info)+1];
						if (array_search('id', $info) !== false) $replace['id'] = $info[array_search('id', $info)+1];
						if (array_search('class', $info) !== false) $replace['class'] = $info[array_search('class', $info)+1];
						$out .= "".($newline === true ? '<tr>':'')."".templatereplace('textarea', $replace)."".($newline === true ? '</tr>':'')."";					
					break;
					/* Beschreibung 	-> 0
					   Type				-> 1
					   Tag min wert		-> 2
					   tag max wert		-> 3
					   Monat min wert	-> 4
					   Monat max wert	-> 5
					   jahr min wert	-> 6
					   Jahr max wert	-> 7

					*/
					case 'date':
						$select = $key;
						$name = $info[0];
						//default werte zuweisen
						if (empty($info[2])) $info[2] = 1;
						if (empty($info[3])) $info[3] = 31;
						if (empty($info[4])) $info[4] = 1;
						if (empty($info[5])) $info[5] = 12;
						if (empty($info[6])) $info[6] = 1920;
						if (empty($info[7])) $info[7] = 2016;
						$option_d = '';
						$option_m = '';
						$option_y = '';

						//tage
						$d = $info[2];
						while($d <= $info[3]) {
							$option_d .= templatereplace('option', array('name' => ''.$d.'','value' => ''.$d.''));
							$d++;
						}
						//in select container packen
						$select = templatereplace('selectf', array('key' => 'day', 'option' => "".$option_d.""));
						$m = $info[4];
						while($m <= $info[5]) {
							$option_m .= templatereplace('option', array('name' => ''.$m.'','value' => ''.$m.''));
							$m++;
						}
						$select .= templatereplace('selectf', array('key' => 'month', 'option' => "".$option_m.""));
						$y = $info[7];
						while($y >= $info[6]) {
							$option_y .= templatereplace('option', array('name' => ''.$y.'','value' => ''.$y.''));
							$y--;
						}
						$select .= templatereplace('selectf', array('key' => 'year', 'option' => "".$option_y.""));
						$replace = array('option' => ''.$select.''
										,'beschreibung' => ''.$name.''
										);
						$out .= "".($newline === true ? '<tr>':'')."".templatereplace('dateselect', $replace)."".($newline === true ? '</tr>':'')."";
					break;
					case 'radio':
						if (!isset($data[$key])) $data[$key] = '';
						$replace = array('id' => ''
										,'name' => ''.$info[2].''
										,'beschreibung' => ''.$info[0].''
										,'value' => ''.$data[$key].''
										,'class' => ''
										,'size' => '');
						$replace['type'] = 'radio';
						if (array_search('id', $info) !== false) $replace['id'] = $info[array_search('id', $info)+1];
						if (array_search('class', $info) !== false) $replace['class'] = $info[array_search('class', $info)+1];
						if (array_search('size', $info) !== false) $replace['size'] = $info[array_search('size', $info)+1];
						$out .= "".($newline === true ? '<tr>':'')."".templatereplace('input', $replace)."".($newline === true ? '</tr>':'')."";
					break;
					case 'enum':
						$select = $key;
						$name = $info[0];
						$option = '';
						unset($info[0]); #lschen Beschreibungstext 
						unset($info[1]); #lschen "enum"
						foreach($info AS $k => $value) {
							$option .= templatereplace('option', array('name' => ''.$value.'','value' => ''.$value.''));
						}
						$replace = array('key' => ''.$key.''
										,'option' => ''.$option.''
										,'beschreibung' => ''.$name.''
										);
						$out .= "".($newline === true ? '<tr>':'')."".templatereplace('select', $replace)."".($newline === true ? '</tr>':'')."";
					break;
				}
			}else{
				//nichts	
			}		
			#<input type="text" name="{name}" {id} value="{value}" {class} {size} /> 

		}
	}else{
		return false;
	}
	$form = $out;
	return $form;
}
/* Gibt eine Fehlermeldung $message aus
 *@param $message text der ausgegeben werden soll

*/
function template_error($messsage,$restorepage = false) {
	global $session;
	if ($restorpage !== false) {
		if (strpos($session['restorpage'], '?')) {
			$url = ''.$session['restorpage'].'&error='.urlencode(''.$messsage.'').'';
		}else{
			$url = ''.$session['restorpage'].'?error='.urlencode(''.$messsage.'').'';
		}
	}else{
		if (strpos($restorepage, '?')) {
			$url = ''.$restorepage.'&error='.urlencode(''.$messsage.'').'';
		}else{
			$url = ''.$restorepage.'?error='.urlencode(''.$messsage.'').'';
		}			
	}
	redirect(''.$url.'');
}
/** Erstellt ein html formular


*/
function create_form_template($form,$data,$url,$newline=true,$method='POST', $enctype = '') {

	$form = array("action"=>''.$url.''
				 ,"method"=>'POST'
				 ,"enctype" => "".$enctype.""
				 ,'form' => "".template_showform($form,$data,$newline).""
				);
	return templatereplace('formular',$form);
}
?>